@readdata_struct_xdf

pro save_webdata

; these variables are filled by the procedure initialize
common paths, work_dir
common times, timall, start_date, end_date, syr, sdoy, eyr, edoy
common files, input_file, save_file, output_file, output_file2, create_save_file

print

; no longer need to read times, these are supplied in timall

 fname    = strarr(1)
 shtim    = strarr(1)

; don't need this, timal is already correct, would be no change
;timall = [start_year,start_day,start_hour,start_mins,stop_year,stop_day,stop_hour,stop_mins]

; this assignment replaces long group of if logic
shtim = string(timall(0),timall(1),timall(4),timall(5), $
  format="(i4,'_',i3.3,'_',i4,'_',i3.3)")

; now read in the pha data files

; read species data
print,'Reading species data from file ',input_file(0)
Nmax_row = 1300000L
readdata_struct_xdf, input_file(0), Nmax_row, xdf
if create_save_file eq 1 then begin
  print,'Saving species data to ',save_file(0)
  save, filename = save_file(0)
endif

; read smoosh data
print,'Reading smoosh data from file ',input_file(1)
Nmax_row = 1300000L
readdata_struct_xdf, input_file(1), Nmax_row, xdf
if create_save_file eq 1 then begin
  print,'Saving smoosh data to ',save_file(1)
  save, filename = save_file(1)
endif

; read mass data
print,'Reading mass data from file ',input_file(2)
Nmax_row = 1300000L
readdata_struct_xdf, input_file(2), Nmax_row, xdf
if create_save_file eq 1 then begin
  print,'Saving mass data to ',save_file(2)
  save, filename = save_file(2)
endif

stop


end

; Locate and compile file init_webdata.pro, which contains the initialize procedure

@init_webdata

; Call initialize to fill in common blocks used by other routines

initialize

end
